/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// Based in part on https://www.shadertoy.com/view/XtsSWM

#define A 2.39996322972865332
#define N 256.0
#define R 0.1
#define PI 3.14159265359    

void mainImage(out vec4 o, in vec2 i) {
    vec2 S=iResolution.xy;
    i = (i+i-S)/S.y;
    
    float w = iGlobalTime * 4.0;
    i*=dot(i,i+vec2(cos(w),sin(w))*0.1); //warp
    
    float r = max(0.1,length(i)-R);
    float v = floor(r*r*N-w);
      
    float c = 1.;
    for(float k = 0.; k < 40.; k++) {
        vec2 p = sqrt((v+w)/N)*cos(v*A+vec2(0., PI/2.))-i;
        c = min(c, dot(p,p));
        v++;
    }
    
    // Opacities fiddled with and ade much redder. TheEmu.
    float e = sqrt(c);
    float g = max(0.,1.-e/R)*max(0.,1.-r);
    float h = ( r > 1.0 ) ? 0.0 : e + (g*sqrt(r)/R) + r;
    o = vec4(g*3.0, g*g, g*0.3, h);
}

void main ( void ) {
    mainImage ( gl_FragColor, gl_FragCoord.xy );
}
